% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rvmkern}
\alias{rvmkern}
\title{Random circular kernel numbers.}
\usage{
rvmkern(n, fit)
}
\arguments{
\item{n}{Integer number of numbers to return.}

\item{fit}{An emprical distribution contained in either a matrix or a fitted \code{actmod} object (see Details).}
}
\value{
A numeric vector of radian numbers.
}
\description{
Random numbers drawn from a fitted Von Mises kernel distribution.
}
\details{
If \code{fit} is a matrix, it should have two columns:
  [,1] precisely seq(0,2*pi,pi/256) sequence of radian values at which pdf evaluated;
  [,2] corresponding pdf values.
}
\examples{
#Matrix input
 data(BCItime)
 tm <- 2*pi*BCItime$time[BCItime$species=="paca"]
 xx <- seq(0,2*pi, pi/256)
 rn <- rvmkern(100, cbind(xx, dvmkern(xx, tm)))

 #actmod input
 fit <- fitact(tm, sample="n")
 rvmkern(100,fit)
}

