\name{pairs.ada}
\alias{pairs.ada}
\alias{varplot}
\title{
  Pairwise Plots and Variable Importancs Plot for Ada 
}

\description{
  This command produces pairwise plots of the data. The data in  
  the upper panel of pairwise plots colors the observations by observed class
  membership (if membership is provided).  The lower panel of pairwise plots
  colors the observations by predicted classes.  In addition, the plotting 
  symbol is scaled by the the class probability estimate from by adaboost.
  
  The \code{varplot} command produces a variable importance plot using the 
  improve criteria given in the reference (Hastie et al.,2001, pg332).  This 
  is a rather standard measure for determining variable importance.
}

\usage{

\method{pairs}{ada}(x, train.data = NULL, vars = NULL, maxvar = 10, 
                    test.x = NULL, test.y = NULL, 
                    test.only = FALSE,col=c(2,4),pch=c(1,2), \dots)

varplot(x, plot.it = TRUE, type = c("none","scores"),max.var.show=30, \dots)
}

\arguments{
  \item{x}{object generated by \sQuote{ada}.}
  \item{train.data}{the \sQuote{data.frame} of the orgianal data used to train the
    classifier.  The names of this \sQuote{data.frame} must be the same as the
    variable names as the object generated by \sQuote{ada}.  x.data is
    used by both the \sQuote{pairs} command.  Default = NULL.
  }
  \item{vars}{a vector of variables to include for this plot.  The
    variable number must correspond to a specific column in \sQuote{x}.  For
    example, vars=c(1,2), generates a plot for the first two columns
    for \sQuote{x.data}.  Note:  vars is only used for the \sQuote{pairs} command.
    Default = NULL.
  }
  \item{maxvar}{the maximum number of variables for the pairwise plot.
    If maxvar = 5, then \sQuote{varplot} chooses the the five most important 
    variables and places these in desending order in the plot.  Maxvar
    is only used for the \sQuote{pairs} command.  Default = 10.
  }
  \item{test.x}{an option to plot pairwise descriptors for a test 
    data set.  \sQuote{test.data} should be of type \sQuote{data.frame}.  \sQuote{test.data} is only 
    used for the \sQuote{pairs} command.  Default = NULL.
  }
  \item{test.y}{the corresponding response for the test data set.
    If \sQuote{test.response} is not specified, then the color of the symbols for 
    the test data in the pairwise plots are black; training data are colored
    by class.  \sQuote{test.response} is only used for the \sQuote{pairs} command.
    Default = NULL.
  }
  \item{test.only}{provides pairwise plots for test data only (test.only = TRUE).
    Default = FALSE.  If \sQuote{test.response} is not specified, then \sQuote{test.only} is ignored. 
    \sQuote{test.only} is only used for the \sQuote{pairs} command.  Default = NULL.
  }
  \item{col}{color for plot symbols one for each class. Defualt col=c(2,4) (i.e. red and blue)}
  \item{pch}{pch for plot set two symbols. Defualt pch=c(1,2) (i.e. circle and triangle)}
  \item{\dots}{Arguments to be passed into \sQuote{pairs.default}.  Do not set
    the upper and lower panel.  This is only used for the pairs command.
  }
  \item{plot.it}{provides a plot of frequencies for each variable (plot.it = TRUE).
\sQuote{plot.it} is only used for the \sQuote{varplot} command.  Default = NULL.
  }
  \item{type}{ if type=\dQuote{none} then nothing is returned.  Default = \dQuote{none}.
    If type=\dQuote{scores}, the frequencies are returned.
  }
  \item{max.var.show}{if plot.it is TRUE then this controls the number of variables shown for the plot}
}

\details{
  The \sQuote{varplot} command provides a sense of variable importance--the more frequently
  a variable is selected for boosting, the more likely the variable contains
  useful information for classification.  Pairwise interactions of important variables
  can then be visualized using \sQuote{varplot}.  Note:  The \sQuote{pairs} command calls 
  the \sQuote{varplot} command.
}

\value{
  \item{scores}{
    If type=\dQuote{scores} then the frequencies for each variable
    is returned by the varplot command.
  }
}

\note{
  This plot was designed as tool to use with adaboost.  Please send any comments
  or suggestions for improvement to the authors.
}

\references{
  Culp, M., Johnson, K., Michailidis, G. (200X). \emph{ada: an R Package
    for Boosting} Journal of Statistical Software, (XX)XX
}

\keyword{ methods }
