% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobenius_norm_funct.R
\name{frobenius_norm_funct}
\alias{frobenius_norm_funct}
\title{Functional Frobenius norm}
\usage{
frobenius_norm_funct(m, PM)
}
\arguments{
\item{m}{Data matrix with the residuals. This matrix has 
the same dimensions as the original data matrix.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}
}
\value{
Real number.
}
\description{
Computes the functional Frobenius norm.
}
\details{
Residuals are vectors. If there are p variables (columns),
for every observation there is a residual that there is 
a p-dimensional vector. If there are n observations, the
residuals are an n times p matrix.
}
\examples{
library(fda)
mat <- matrix(1:9, nrow = 3)
fbasis <- create.fourier.basis(rangeval = c(1, 32), nbasis = 3)
PM <- eval.penalty(fbasis)
frobenius_norm_funct(mat, PM)
                 
}
\author{
Guillermo Vinue
}
