% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archetypoids_funct_robust.R
\name{archetypoids_funct_robust}
\alias{archetypoids_funct_robust}
\title{Archetypoid algorithm with the functional robust Frobenius norm}
\usage{
archetypoids_funct_robust(numArchoid, data, huge = 200, ArchObj, PM, prob)
}
\arguments{
\item{numArchoid}{Number of archetypoids.}

\item{data}{Data matrix. Each row corresponds to an observation and each column 
corresponds to a variable. All variables are numeric.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{ArchObj}{The list object returned by the 
\code{\link{stepArchetypesRawData_funct_robust}} function.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}

\item{prob}{Probability with values in [0,1].}
}
\value{
A list with the following elements:
\itemize{
\item cases: Final vector of archetypoids.
\item rss: Residual sum of squares corresponding to the final vector of archetypoids.
\item archet_ini: Vector of initial archetypoids.
\item alphas: Alpha coefficients for the final vector of archetypoids.
\item resid: Matrix with the residuals.
}
}
\description{
Archetypoid algorithm with the functional robust Frobenius norm 
to be used with functional data.
}
\examples{
\dontrun{
library(fda)
?growth
str(growth)
hgtm <- t(growth$hgtm)
# Create basis:
basis_fd <- create.bspline.basis(c(1,ncol(hgtm)), 10)
PM <- eval.penalty(basis_fd)
# Make fd object:
temp_points <- 1:ncol(hgtm)
temp_fd <- Data2fd(argvals = temp_points, y = growth$hgtm, basisobj = basis_fd)
data_archs <- t(temp_fd$coefs)

lass <- stepArchetypesRawData_funct_robust(data = data_archs, numArch = 3, 
                                           numRep = 5, verbose = FALSE, 
                                           saveHistory = FALSE, PM, prob = 0.8)

afr <- archetypoids_funct_robust(3, data_archs, huge = 200, ArchObj = lass, PM, 0.8)
str(afr)
}                                                          
                                                     
}
\references{
Moliner, J. and Epifanio, I., Robust multivariate and functional archetypal analysis 
with application to financial time series analysis, 2018, submitted,
\url{https://arxiv.org/abs/1810.00919}
}
\seealso{
\code{\link[Anthropometry]{archetypoids}}
}
\author{
Irene Epifanio
}
