% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archetypoids_robust.R
\name{archetypoids_robust}
\alias{archetypoids_robust}
\title{Archetypoid algorithm with the robust Frobenius norm}
\usage{
archetypoids_robust(numArchoid, data, huge = 200, ArchObj, prob)
}
\arguments{
\item{numArchoid}{Number of archetypoids.}

\item{data}{Data matrix. Each row corresponds to an observation and each column 
corresponds to a variable. All variables are numeric.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{ArchObj}{The list object returned by the 
\code{\link{stepArchetypesRawData_robust}} function.}

\item{prob}{Probability with values in [0,1].}
}
\value{
A list with the following elements:
\itemize{
\item cases: Final vector of archetypoids.
\item rss: Residual sum of squares corresponding to the final vector of archetypoids.
\item archet_ini: Vector of initial archetypoids.
\item alphas: Alpha coefficients for the final vector of archetypoids.
\item resid: Matrix with the residuals.
}
}
\description{
Robust version of the archetypoid algorithm with the Frobenius form.
}
\examples{
data(mtcars)
data <- mtcars

k <- 3
numRep <- 2
huge <- 200

lass <- stepArchetypesRawData_robust(data = data, numArch = k, 
                                     numRep = numRep, verbose = FALSE, 
                                     saveHistory = FALSE, prob = 0.8)

res <- archetypoids_robust(k, data, huge, ArchObj = lass, 0.8)
str(res)    
res$cases
res$rss                                                           
              
}
\references{
Moliner, J. and Epifanio, I., Robust multivariate and functional archetypal analysis 
with application to financial time series analysis, 2019. 
\emph{Physica A: Statistical Mechanics and its Applications} \bold{519}, 195-208. 
\url{https://doi.org/10.1016/j.physa.2018.12.036}
}
\seealso{
\code{\link{archetypoids_norm_frob}}
}
\author{
Irene Epifanio
}
