% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_plots.R
\name{make_y_scale}
\alias{make_y_scale}
\title{Make y-axis scale for history/status plots}
\usage{
make_y_scale(y_value)
}
\arguments{
\item{y_value}{single character string, determining which values are plotted
on the y-axis. The following options are available: allocation
probabilities (\code{"prob"}, default), the total number of patients allocated
to each arm (\code{"n"}), the percentage of patients allocated to each arm of
the total number of patients randomised (\code{"pct"}), the sum of all outcomes
in each arm (\code{"sum ys"}), the ratio of outcomes (\code{"ratio ys"}, the sum of
outcomes in each arm divided by the number of patients allocated to that
arm).}
}
\value{
An appropriate scale for the \code{ggplot2} plot y-axis according to
the value specified in \code{y_value}.
}
\description{
Used internally. Prepares the y-axis scale for history/status plots.
Requires the \code{ggplot2} package installed.
}
\keyword{internal}
