% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{pareto_chart.data.frame}
\alias{pareto_chart.data.frame}
\title{Pareto's chart}
\usage{
\method{pareto_chart}{data.frame}(obj, labels, values, ...)
}
\arguments{
\item{obj}{a data frame}

\item{labels}{the column with the labels of the data frame}

\item{values}{the column with the values of the data frame}

\item{...}{further parameters (currently unused)}
}
\value{
a Pareto chart (GGPlot2 object) of the data frame

Invisibly returns a data frame with the absolute values of the
data frame, their sign, and the cumulative value.
}
\description{
Create a Pareto chart for a data frame.
}
\examples{
library(tibble)
set.seed(1)
tibble(
  val=rnorm(10, sd=5),
  cat=LETTERS[1:length(val)]
  ) \%>\%
  pareto_chart(labels=cat, values=val)
}
