% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial_plan.R
\name{fp_design_matrix}
\alias{fp_design_matrix}
\title{Factorial Plan Design Matrix}
\usage{
fp_design_matrix(arg, rep = 1, levels = c(-1, 1))
}
\arguments{
\item{arg}{Either a formula or a number of factors. If it is a formula, the
factors are extracted from it. If it is a number, the factors are the first
\code{n} capital letters.}

\item{rep}{Number of replications.}

\item{levels}{Levels of the factors.}
}
\value{
A design matrix: a subclass of a tibble of class \code{factorial.plan}.
The class has the following attributes:
\describe{
\item{\code{def.rel}}{The defining relationship (a formula).}
\item{\code{generators}}{The list of generators (formulas) if the factorial plan is fractional.}
\item{\code{fraction}}{The list of fractions (character vectors) if the factorial plan is fractional.}
\item{\code{levels}}{The levels of the factors (all equal), in coded units.}
\item{\code{scales}}{A list: for each factor, a vector of two values corresponding to the extreme values in coded units.}
}
}
\description{
Builds a design matrix from a one side formula or a number of factors.
}
\details{
Defining relationships are represented as one side formulas, e.g. $I=ABC$
becomes \code{~A*B*C}.
}
\examples{
fp_design_matrix(3, rep=2, levels=c("-", "+"))
}
