% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AV_AH.R
\name{calcular_AV_AH}
\alias{calcular_AV_AH}
\title{Calcular Análise Vertical e Horizontal com projeção}
\usage{
calcular_AV_AH(df, tipo)
}
\arguments{
\item{df}{Um data frame contendo os dados contábeis. Deve conter colunas com valores numéricos para diferentes anos, além de uma coluna identificadora da natureza das contas (por exemplo, \code{"Categoria"} ou \code{"Conta"}).}

\item{tipo}{Um parâmetro do tipo \code{character} que indica a estrutura do data frame. Deve ser \code{"agregado"} quando os dados estão organizados por categorias (ex: ACO, ANC, PL etc.), ou outro valor (ex: \code{"detalhado"}) quando as contas individuais estão identificadas por uma coluna chamada \code{"Conta"}.}
}
\value{
Uma lista com dois data frames:
\describe{
  \item{\code{AV_AH}}{Data frame contendo os valores originais, os resultados da Análise Vertical (com sufixo \code{_AV}) e da Análise Horizontal (com sufixo \code{_AH}).}
  \item{\code{Projecao}}{Data frame contendo a projeção de valores para o ano seguinte, com base em um crescimento de 5\%.}
}
}
\description{
Esta função realiza a Análise Vertical (AV) e Análise Horizontal (AH) com base em dados contábeis de empresas, podendo ser aplicada tanto a dados agregados quanto a dados detalhados (ex: Balanço Patrimonial individualizado). Além disso, gera uma projeção para o ano seguinte, assumindo um crescimento de 5% nos valores.
}
\details{
A Análise Vertical (AV) expressa cada item patrimonial como uma proporção do total do ativo ou passivo correspondente no mesmo ano.

A Análise Horizontal (AH) compara a evolução dos valores ao longo dos anos, em relação ao primeiro ano da base de dados (ano base).

A função ainda projeta valores para o ano seguinte com base em um crescimento linear de 5% sobre os valores do último ano disponível.
}
\examples{
# Criando dados agregados de exemplo
df <- data.frame(
  Conta = c("Ativo Circulante", "Passivo Circulante"),
  X2022 = c(1000, 800),
  X2023 = c(1200, 900)
)

# Padronizando o balanço
resultado <- padronizar_balanco(df)

# Calculando análise vertical e horizontal para dados agregados
av_ah <- calcular_AV_AH(resultado$agregado, tipo = "agregado")

# Visualizando partes do resultado
head(av_ah$AV_AH)
head(av_ah$Projecao)
}
