% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{read.fstat}
\alias{read.fstat}
\title{Reading data from Fstat}
\usage{
read.fstat(file, quiet = FALSE)
}
\arguments{
\item{file}{a character string giving the path to the file to convert, with
the appropriate extension.}

\item{quiet}{logical stating whether a conversion message must be printed
(TRUE,default) or not (FALSE).}
}
\value{
an object of the class \code{genind}
}
\description{
The function \code{read.fstat} reads Fstat data files (.dat) and convert
them into a \linkS4class{genind} object.
}
\details{
Note: \code{read.fstat} is meant for DIPLOID DATA ONLY. Haploid data with
the Hierfstat format can be read into R using \code{read.table} or
\code{read.csv} after removing headers and 'POP' lines, and then converted
using \code{\link{df2genind}}.
}
\examples{

obj <- read.fstat(system.file("files/nancycats.dat",package="adegenet"))
obj

}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\references{
Fstat (version 2.9.3). Software by Jerome Goudet.
http://www2.unil.ch/popgen/softwares/fstat.htm\cr
}
\seealso{
\code{\link{import2genind}}, \code{\link{df2genind}},
\code{\link{read.genetix}}, \code{\link{read.structure}},
\code{\link{read.genepop}}
}
\keyword{manip}

