% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.dense}
\alias{matrix.dense}
\title{Creates a viewer of a dense matrix.}
\usage{
matrix.dense(mat, method = "naive", n_threads = 1)
}
\arguments{
\item{mat}{The dense matrix.}

\item{method}{Method type.}

\item{n_threads}{Number of threads.}
}
\value{
Dense matrix.
}
\description{
Creates a viewer of a dense matrix.
}
\examples{
n <- 100
p <- 20
X_dense <- matrix(rnorm(n * p), n, p)
out <- matrix.dense(X_dense, method="naive")
A_dense <- t(X_dense) \%*\% X_dense
out <- matrix.dense(A_dense, method="cov")
}
