% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glintnet.R, R/wrappers.R
\name{plot.cv.glintnet}
\alias{plot.cv.glintnet}
\alias{plot.cv.grpnet}
\title{plot the cross-validation curve produced by cv.glintnet}
\usage{
\method{plot}{cv.glintnet}(x, sign.lambda = -1, ...)

\method{plot}{cv.grpnet}(x, sign.lambda = -1, ...)
}
\arguments{
\item{x}{fitted \code{"cv.grpnet"} object}

\item{sign.lambda}{Either plot against \code{log(lambda)} or its
negative (default) if \code{sign.lambda=-1}}

\item{\dots}{Other graphical parameters}
}
\description{
Plots the cross-validation curve, and upper and lower standard deviation
curves, as a function of the \code{lambda} values used.

Plots the cross-validation curve, and upper and lower standard deviation
curves, as a function of the \code{lambda} values used.
}
\details{
A plot is produced, and nothing is returned.

A plot is produced, and nothing is returned.
}
\examples{
set.seed(0)
n=500
d_cont = 5     # number of continuous features
d_disc = 5     # number of categorical features
Z_cont = matrix(rnorm(n*d_cont), n, d_cont)
levels = sample(2:5,d_disc, replace = TRUE)
Z_disc = matrix(0,n,d_disc)
for(i in seq(d_disc))Z_disc[,i] = sample(0:(levels[i]-1),n,replace=TRUE)
Z = cbind(Z_cont,Z_disc)
levels = c(rep(1,d_cont),levels)

xmat = model.matrix(~Z_cont[,1]*factor(Z_disc[,2]))
nc=ncol(xmat)
beta = rnorm(nc)
y = xmat\%*\%beta+rnorm(n)*1.5

cvfit <- cv.glintnet(Z, glm.gaussian(y), levels=levels, intr_keys = 1)
plot(cvfit)


set.seed(1010)
n = 1000
p = 100
nzc = trunc(p/10)
x = matrix(rnorm(n * p), n, p)
beta = rnorm(nzc)
fx = (x[, seq(nzc)] \%*\% beta)
eps = rnorm(n) * 5
y = drop(fx + eps)
px = exp(fx)
px = px/(1 + px)
ly = rbinom(n = length(px), prob = px, size = 1)
cvob1 = cv.grpnet(x, glm.gaussian(y))
plot(cvob1)
title("Gaussian Family", line = 2.5)
frame()
set.seed(1011)
cvob2 = cv.grpnet(x, glm.binomial(ly))
plot(cvob2)
title("Binomial Family", line = 2.5)

}
\references{
Yang, James and Hastie, Trevor. (2024) A Fast and Scalable Pathwise-Solver for Group Lasso
and Elastic Net Penalized Regression via Block-Coordinate Descent. arXiv \doi{10.48550/arXiv.2405.08631}.\cr
Adelie Python user guide  \url{https://jamesyang007.github.io/adelie/}
}
\seealso{
\code{grpnet} and \code{cv.grpnet}.
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan \cr Maintainer:
Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{group}
\keyword{lasso}
\keyword{models}
\keyword{regression}
