% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glintnet.R
\name{predict.glintnet}
\alias{predict.glintnet}
\alias{coef.glintnet}
\title{make predictions from a "glintnet" object.}
\usage{
\method{predict}{glintnet}(
  object,
  newx,
  lambda = NULL,
  type = c("link", "response", "coefficients", "nonzero"),
  newoffsets = NULL,
  n_threads = 1,
  ...
)
}
\arguments{
\item{object}{Fitted \code{"glintnet"} model.}

\item{newx}{Matrix of new values for \code{x} at which predictions are to be
made. This matrix is of the same form as in the call to \code{glintnet}.}

\item{lambda}{Value(s) of the penalty parameter \code{lambda} at which
predictions are required. Default is the entire sequence used to create the
model. If values of \code{lambda} are supplied, the function uses linear
interpolation to make predictions for values of \code{lambda} that do
not coincide with those used in the fitting algorithm. Note: if newx is a vector
(a single row which has lost its matrix dimensions), convert it to a 1-row matrix first, e.g. by supplying t(newx) instead.}

\item{type}{Type of prediction required. Type \code{"link"} is  the default, and gives the linear
predictors. Type \code{"response"} applies the inverse link to these predictions.
Type \code{"coefficients"} extracts the coefficients, intercepts and the active-set sizes.
Type \code{"nonzero"} returns a list of active groups along the path, indexed from 1 to number of groups.}

\item{newoffsets}{If an offset is used in the fit, then one must be supplied
for making predictions (except for \code{type="coefficients"}.}

\item{n_threads}{Number of threads, default \code{1}.}

\item{\dots}{Other arguments that can be passed to \code{predict.grpnet}}
}
\value{
The object returned depends on type.
}
\description{
Similar to other predict methods, this functions predicts linear predictors,
coefficients and more from a fitted \code{"glintnet"} object.
}
\examples{
set.seed(0)
n=500
d_cont = 5     # number of continuous features
d_disc = 5     # number of categorical features
Z_cont = matrix(rnorm(n*d_cont), n, d_cont)
levels = sample(2:5,d_disc, replace = TRUE)
Z_disc = matrix(0,n,d_disc)
for(i in seq(d_disc))Z_disc[,i] = sample(0:(levels[i]-1),n,replace=TRUE)
Z = cbind(Z_cont,Z_disc)
levels = c(rep(1,d_cont),levels)

xmat = model.matrix(~Z_cont[,1]*factor(Z_disc[,2]))
nc=ncol(xmat)
beta = rnorm(nc)
y = xmat\%*\%beta+rnorm(n)*1.5

fit <- glintnet(Z, glm.gaussian(y), levels=levels, intr_keys = 1)
predict(fit, lambda = c(.1,.01), newx = Z[1:4,])
predict(fit, lambda = c(0.1,0.01), type="nonzero")

}
\references{
Yang, James and Hastie, Trevor. (2024) A Fast and Scalable Pathwise-Solver for Group Lasso
and Elastic Net Penalized Regression via Block-Coordinate Descent. arXiv \doi{10.48550/arXiv.2405.08631}.\cr
Adelie Python user guide  \url{https://jamesyang007.github.io/adelie/}
}
\seealso{
\code{grpnet}, and \code{print}, and \code{coef} methods, and
\code{cv.grpnet}.
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan \cr Maintainer: Trevor Hastie
\email{hastie@stanford.edu}
}
\keyword{models}
\keyword{regression}
