% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/moranNP.randtest.R
\name{moranNP.randtest}
\alias{moranNP.randtest}
\title{Function to compute positive and negative parts of Moran's index of spatial
autocorrelation}
\usage{
moranNP.randtest(x, listw, nrepet = 999, alter = c("greater", "less",
  "two-sided"), ...)
}
\arguments{
\item{x}{a \code{vector} with numeric data}

\item{listw}{an object of class \code{listw} created for example by
\code{\link[spdep]{nb2listw}}}

\item{nrepet}{an integer indicating the number of permutations used in the
randomization procedure}

\item{alter}{a character string specifying the alternative hypothesis, must
be one of "greater" (default), "less" or "two-sided"}

\item{\dots}{other arguments (e.g., \code{p.adjust.method}) to be passed to
the code{\link[ade4]{as.krandtest}} function.}
}
\value{
An object of class \code{randtest} (for unilateral test) or
  \code{krandtest} (for bilateral test)
}
\description{
This function computes positive and negative parts of Moran's I statistic and
provide a testing procedure using random permutations. The functions compute
the Moran's eigenvector maps (MEM) and eigenvalues for the \code{listw}
object. If \code{alter = "greater"}, the statistic 'I+' is computed as the
sum of the products between positive eigenvalues and squared correlations
between \code{x} and associated MEMs. If \code{alter = "less"}, the statistic
'I-' is computed as the sum of the products between negative eigenvalues and
squared correlations between \code{x} and associated MEMs. If \code{alter =
"two-sided"}, both statistics are computed.
}
\examples{
if(require("ade4", quietly = TRUE)  & require("spdep", quiet = TRUE)){
data(mafragh)
tests <- moranNP.randtest(mafragh$mil[,1], nb2listw(mafragh$nb),
 alter = "two-sided", p.adjust.method = "holm")
tests
moran.randtest(mafragh$mil[,1], nb2listw(mafragh$nb))$obs
sum(tests$obs)
}
}
\author{
Stéphane Dray \email{stephane.dray@univ-lyon1.fr}
}
\references{
Dray, S. (2011). A new perspective about Moran’s coefficient:
  spatial autocorrelation as a linear regression problem. Geographical
  Analysis, 43, 127–141.
}
\seealso{
\code{\link{moran.randtest}}
}
\keyword{spatial}

