% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.R
\name{read_adf_block}
\alias{read_adf_block}
\alias{read_adf_block.adf_device}
\alias{write_adf_block}
\alias{write_adf_block.adf_device}
\alias{write_adf_block.adf_device.raw}
\alias{write_adf_block.adf_device.adf_block}
\alias{write_adf_block.adf_device.default}
\alias{as_adf_block}
\alias{new_adf_block}
\title{Read or write raw data blocks to a virtual device}
\usage{
read_adf_block(dev, sector, ...)

\method{read_adf_block}{adf_device}(dev, sector, ...)

write_adf_block(dev, sector, data, ...)

\method{write_adf_block}{adf_device}(dev, sector, data, ...)

\method{write_adf_block.adf_device}{raw}(dev, sector, data, ...)

\method{write_adf_block.adf_device}{adf_block}(dev, sector, data, ...)

\method{write_adf_block.adf_device}{default}(dev, sector, data, ...)

as_adf_block(data, ...)

new_adf_block()
}
\arguments{
\item{dev}{The virtual adf device for which information needs to be obtained.
It should be of class \code{adf_device} which can be created with \code{\link[=create_adf_device]{create_adf_device()}}
or \code{\link[=connect_adf]{connect_adf()}}.}

\item{sector}{Sector ID of the block you wish to read/write. It is an integer value.
For double density disks, the ID ranges from 0 to 1759.}

\item{...}{Ignored}

\item{data}{Block data (\code{raw} vector of length 512) you wish to write to a virtual device}
}
\value{
In case of \code{write_adf_block} \code{NULL} is returned invisibly. In case of \code{read_adf_block}
the \code{raw} data is returned as a \code{adf_block} class object.
}
\description{
The Amiga file system is structured around 512 byte blocks. A double density
floppy disk consists of 1760 blocks of 512 bytes. \code{read_adf_block} and \code{write_adf_block}
can be used to transform raw data from and to virtual devices (created with
\code{\link[=create_adf_device]{create_adf_device()}} or \code{\link[=connect_adf]{connect_adf()}}). Note that writing raw data to
a disk could corrupt the file system on the device. So it is generally not
advised unless you know what you are doing.
}
\author{
Pepijn de Vries
}
