% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_query_data.R
\name{get_terms_from_db}
\alias{get_terms_from_db}
\title{Get Terms from the Queries Database}
\usage{
get_terms_from_db(
  version,
  fun,
  queries,
  definition,
  expect_query_name = FALSE,
  expect_query_id = FALSE,
  i,
  temp_env
)
}
\arguments{
\item{version}{Version

The version must be non null. Otherwise, an error is issued. The value is
passed to the access function (\code{fun}).}

\item{fun}{Access function

The access function must be non null. Otherwise, an error is issued. The
function is called to retrieve the terms.}

\item{queries}{Queries

List of all queries passed to \code{create_query_data()}. It is used for error
messages.}

\item{definition}{Definition of the query

The definition is passed to the access function. It defines which terms are
returned.}

\item{expect_query_name}{Is \code{QUERY_NAME} expected in the output dataset?}

\item{expect_query_id}{Is \code{QUERY_ID} expected in the output dataset?}

\item{i}{Index of \code{definition} in \code{queries}

The value is used for error messages.}

\item{temp_env}{Temporary environment

The value is passed to the access function.}
}
\value{
Output dataset of the access function
}
\description{
The function checks if all requirements to access the database are fulfilled
(version and access function are available, see \code{assert_db_requirements()}),
reads the terms from the database, and checks if the dataset with the terms
is in the expected format (see \code{assert_terms()}).
}
\seealso{
OCCDS Functions: 
\code{\link{derive_var_trtemfl}()},
\code{\link{derive_vars_atc}()},
\code{\link{derive_vars_query}()}
}
\concept{der_occds}
\keyword{der_occds}
