% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_merged.R
\name{derive_var_merged_cat}
\alias{derive_var_merged_cat}
\title{Merge a Categorization Variable}
\usage{
derive_var_merged_cat(
  dataset,
  dataset_add,
  by_vars,
  order = NULL,
  new_var,
  source_var,
  cat_fun,
  filter_add = NULL,
  mode = NULL,
  missing_value = NA_character_
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected.}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars}, the \code{source_var}, and the \code{order}
argument are expected.}

\item{by_vars}{Grouping variables

The input dataset and the selected observations from the additional dataset
are merged by the specified by variables. The by variables must be a unique
key of the selected observations. Variables from the additional dataset can
be renamed by naming the element, i.e., \verb{by_vars = exprs(<name in input dataset> = <name in additional dataset>)}, similar to
the dplyr joins.

\emph{Permitted Values}: list of variables created by \code{exprs()}}

\item{order}{Sort order

If the argument is set to a non-null value, for each by group the first or
last observation from the additional dataset is selected with respect to the
specified order.

Variables defined by the \code{new_vars} argument can be used in the sort order.

\emph{Permitted Values}: list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))} or \code{NULL}}

\item{new_var}{New variable

The specified variable is added to the additional dataset and set to the
categorized values, i.e., \verb{cat_fun(<source variable>)}.}

\item{source_var}{Source variable}

\item{cat_fun}{Categorization function

A function must be specified for this argument which expects the values of
the source variable as input and returns the categorized values.}

\item{filter_add}{Filter for additional dataset (\code{dataset_add})

Only observations fulfilling the specified condition are taken into account
for merging. If the argument is not specified, all observations are
considered.

Variables defined by the \code{new_vars} argument can be used in the filter
condition.

\emph{Permitted Values}: a condition}

\item{mode}{Selection mode

Determines if the first or last observation is selected. If the \code{order}
argument is specified, \code{mode} must be non-null.

If the \code{order} argument is not specified, the \code{mode} argument is ignored.

\emph{Permitted Values}: \code{"first"}, \code{"last"}, \code{NULL}}

\item{missing_value}{Values used for missing information

The new variable is set to the specified value for all by groups without
observations in the additional dataset.

\emph{Default}: \code{NA_character_}}
}
\value{
The output dataset contains all observations and variables of the
input dataset and additionally the variable specified for \code{new_var} derived
from the additional dataset (\code{dataset_add}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, please use \code{derive_vars_merged()} instead.

Merge a categorization variable from a dataset to the input dataset. The
observations to merge can be selected by a condition and/or selecting the
first or last observation for each by group.
}
\details{
\enumerate{
\item The additional dataset is restricted to the observations matching the
\code{filter_add} condition.
\item The categorization variable is added to the additional dataset.
\item If \code{order} is specified, for each by group the first or last observation
(depending on \code{mode}) is selected.
\item The categorization variable is merged to the input dataset.
}
}
\examples{
library(dplyr, warn.conflicts = FALSE)

vs <- tribble(
  ~STUDYID,  ~DOMAIN,  ~USUBJID,      ~VISIT, ~VSTESTCD, ~VSSTRESN, ~VSSEQ,       ~VSDTC,
  "PILOT01",    "VS", "04-1127", "SCREENING",  "HEIGHT",     165.1,     43, "2013-09-16",
  "PILOT01",    "VS", "04-1127", "SCREENING",  "WEIGHT",     42.87,    142, "2013-09-16",
  "PILOT01",    "VS", "04-1127",  "BASELINE",  "WEIGHT",     41.05,    143, "2013-10-02",
  "PILOT01",    "VS", "04-1127",    "WEEK 2",  "WEIGHT",     42.64,    144, "2013-10-16",
  "PILOT01",    "VS", "04-1127",    "WEEK 4",  "WEIGHT",     41.73,    145, "2013-10-30",
  "PILOT01",    "VS", "04-1127",   "WEEK 26",  "WEIGHT",     43.09,    152, "2014-03-31",
  "PILOT01",    "VS", "06-1049", "SCREENING",  "HEIGHT",    167.64,     28, "2013-04-30",
  "PILOT01",    "VS", "06-1049", "SCREENING",  "WEIGHT",     57.61,     92, "2013-04-30",
  "PILOT01",    "VS", "06-1049",  "BASELINE",  "WEIGHT",     57.83,     93, "2013-05-14",
  "PILOT01",    "VS", "06-1049",    "WEEK 2",  "WEIGHT",     58.29,     94, "2013-05-28",
  "PILOT01",    "VS", "06-1049",    "WEEK 4",  "WEIGHT",     58.97,     95, "2013-06-11"
)

dm <- tribble(
  ~STUDYID,  ~DOMAIN,  ~USUBJID, ~AGE,   ~AGEU,
  "PILOT01",    "DM", "01-1057",   59, "YEARS",
  "PILOT01",    "DM", "04-1127",   84, "YEARS",
  "PILOT01",    "DM", "06-1049",   60, "YEARS"
)
wgt_cat <- function(wgt) {
  case_when(
    wgt < 50 ~ "low",
    wgt > 90 ~ "high",
    TRUE ~ "normal"
  )
}

derive_var_merged_cat(
  dm,
  dataset_add = vs,
  by_vars = exprs(STUDYID, USUBJID),
  order = exprs(VSDTC, VSSEQ),
  filter_add = VSTESTCD == "WEIGHT" & substr(VISIT, 1, 9) == "SCREENING",
  new_var = WGTBLCAT,
  source_var = VSSTRESN,
  cat_fun = wgt_cat,
  mode = "last"
) \%>\%
  select(STUDYID, USUBJID, AGE, AGEU, WGTBLCAT)



# defining a value for missing VS data
derive_var_merged_cat(
  dm,
  dataset_add = vs,
  by_vars = exprs(STUDYID, USUBJID),
  order = exprs(VSDTC, VSSEQ),
  filter_add = VSTESTCD == "WEIGHT" & substr(VISIT, 1, 9) == "SCREENING",
  new_var = WGTBLCAT,
  source_var = VSSTRESN,
  cat_fun = wgt_cat,
  mode = "last",
  missing_value = "MISSING"
) \%>\%
  select(STUDYID, USUBJID, AGE, AGEU, WGTBLCAT)
}
\seealso{
Other deprecated: 
\code{\link{derive_param_extreme_event}()},
\code{\link{derive_var_basetype}()},
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_disposition_status}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_var_worst_flag}()},
\code{\link{derive_vars_disposition_reason}()},
\code{\link{derive_vars_last_dose}()},
\code{\link{format_eoxxstt_default}()},
\code{\link{format_reason_default}()}
}
\concept{deprecated}
\keyword{deprecated}
