% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_base.R
\name{derive_var_base}
\alias{derive_var_base}
\title{Derive Baseline Variables}
\usage{
derive_var_base(
  dataset,
  by_vars,
  source_var = AVAL,
  new_var = BASE,
  filter = ABLFL == "Y"
)
}
\arguments{
\item{dataset}{The input dataset}

\item{by_vars}{Grouping variables uniquely identifying a set
of records for which to calculate \code{new_var}}

\item{source_var}{The column from which to extract the baseline value, e.g. \code{AVAL}}

\item{new_var}{The name of the newly created baseline column, e.g. \code{BASE}}

\item{filter}{The condition used to filter \code{dataset} for baseline records.

By default \code{ABLFL == "Y"}}
}
\value{
A new \code{data.frame} containing all records and variables of the input
dataset plus the \code{new_var} variable
}
\description{
Derive baseline variables, e.g. \code{BASE} or \code{BNRIND}, in a BDS dataset
}
\details{
For each \code{by_vars} group the baseline record is identified by filtering using the
condition specified by \code{filter} which defaults to \code{ABLFL == "Y"}. Subsequently,
every value of the \code{new_var} variable for the \code{by_vars} group is set to the
value of the \code{source_var} variable of the baseline record. In case there are
multiple baseline records within \code{by_vars} an error is issued.
}
\examples{
dataset <- tibble::tribble(
  ~STUDYID, ~USUBJID, ~PARAMCD,  ~AVAL,  ~AVALC,   ~AVISIT,    ~ABLFL,
  "TEST01", "PAT01",  "PARAM01", 10.12,  NA,       "Baseline", "Y",
  "TEST01", "PAT01",  "PARAM01",  9.7,   NA,       "Day 7",    "N",
  "TEST01", "PAT01",  "PARAM01", 15.01,  NA,       "Day 14",   "N",
  "TEST01", "PAT01",  "PARAM02",  8.35,  NA,       "Baseline", "Y",
  "TEST01", "PAT01",  "PARAM02", NA,     NA,       "Day 7",    "N",
  "TEST01", "PAT01",  "PARAM02",  8.35,  NA,       "Day 14",   "N",
  "TEST01", "PAT01",  "PARAM03", NA,     "LOW",    "Baseline", "Y",
  "TEST01", "PAT01",  "PARAM03", NA,     "LOW",    "Day 7",    "N",
  "TEST01", "PAT01",  "PARAM03", NA,     "MEDIUM", "Day 14",   "N",
  "TEST01", "PAT01",  "PARAM04", NA,     "HIGH",   "Baseline", "Y",
  "TEST01", "PAT01",  "PARAM04", NA,     "HIGH",   "Day 7",    "N",
  "TEST01", "PAT01",  "PARAM04", NA,     "MEDIUM", "Day 14",   "N"
)

## Derive `BASE` variable from `AVAL`
derive_var_base(
  dataset,
  by_vars = vars(USUBJID, PARAMCD),
  source_var = AVAL,
  new_var = BASE
)

## Derive `BASEC` variable from `AVALC`
derive_var_base(
  dataset,
  by_vars = vars(USUBJID, PARAMCD),
  source_var = AVALC,
  new_var = BASEC
)

## Derive `BNRIND` variable from `ANRIND`
if (FALSE) {
  derive_var_base(
    dataset,
    by_vars = vars(USUBJID, PARAMCD),
    source_var = ANRIND,
    new_var = BNRIND
  )
}
}
\author{
Thomas Neitmann
}
\keyword{bds}
\keyword{derivation}
