% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_helpers.R
\name{expect_dfs_equal}
\alias{expect_dfs_equal}
\title{Expectation: Are Two Datasets Equal?}
\usage{
expect_dfs_equal(base, compare, keys, ...)
}
\arguments{
\item{base}{Input dataset}

\item{compare}{Comparison dataset}

\item{keys}{\code{character} vector of variables that define a unique row in the
\code{base} and \code{compare} datasets}

\item{...}{Additional arguments passed onto \code{\link[diffdf:diffdf]{diffdf::diffdf()}}}
}
\value{
An error if \code{base} and \code{compare} do not match or \code{NULL} invisibly if they do
}
\description{
Uses \code{\link[diffdf:diffdf]{diffdf::diffdf()}} to compares 2 datasets for any differences
}
\examples{
\dontrun{
testthat::test_that("a missing row is detected", {
  data(dm)
  expect_dfs_equal(dm, dm[-1L, ], keys = "USUBJID")
})
}
}
\author{
Thomas Neitmann
}
\keyword{dev_utility}
\keyword{test_helper}
