% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BVdk_estimParam.R
\name{BVdk_estimParam}
\alias{BVdk_estimParam}
\title{Estimation of the parameters in a two-component admixture model with symmetric unknown density}
\usage{
BVdk_estimParam(
  data,
  method = c("L-BFGS-B", "Nelder-Mead"),
  comp.dist,
  comp.param
)
}
\arguments{
\item{data}{The observed sample under study.}

\item{method}{The method used throughout the optimization process, either 'L-BFGS-B' or 'Nelder-Mead' (see ?optim).}

\item{comp.dist}{A list with two elements corresponding to component distributions (specified with R native names for these distributions) involved
in the admixture model. Unknown elements must be specified as 'NULL' objects, e.g. when 'f' is unknown: list(f=NULL, g='norm').}

\item{comp.param}{A list with two elements corresponding to the parameters of the component distributions, each element being a list
itself. The names used in this list must correspond to the native R argument names for these distributions.
Unknown elements must be specified as 'NULL' objects, e.g. if 'f' is unknown: list(f=NULL, g=list(mean=0,sd=1)).}
}
\value{
A numeric vector with the two estimated parameters (proportion first, and then location shift).
}
\description{
Estimation of the two parameters (mixture weight as well as location shift) in the admixture model with pdf:
l(x) = p*f(x-mu) + (1-p)*g(x), x in R,
where g is the known component, p is the proportion and f is the unknown component with symmetric density.
The localization shift parameter is thus denoted mu, and the component weight p.
See 'Details' below for further information.
}
\details{
Parameters are estimated by minimization of the contrast function, where the contrast is defined in
Bordes, L. and Vandekerkhove, P. (2010); Semiparametric two-component mixture model when a component is known:
an asymptotically normal estimator; Math. Meth. Stat.; 19, pp. 22--41.
}
\examples{
## Simulate data:
list.comp <- list(f = 'norm', g = 'norm')
list.param <- list(f = list(mean = 3, sd = 0.5),
                   g = list(mean = 0, sd = 1))
data1 <- rsimmix(n = 150, unknownComp_weight = 0.9, list.comp, list.param)[['mixt.data']]
## Perform the estimation of parameters in real-life:
list.comp <- list(f = NULL, g = 'norm')
list.param <- list(f = NULL, g = list(mean = 0, sd = 1))
BVdk_estimParam(data1, method = 'L-BFGS-B', list.comp, list.param)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
