% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_admix.R
\name{plot_admix}
\alias{plot_admix}
\title{Plot the density of some given sample(s)}
\usage{
plot_admix(
  sim.X,
  sim.Y = NULL,
  user.bounds = NULL,
  support = c("continuous", "discrete"),
  case = ""
)
}
\arguments{
\item{sim.X}{First sample from which the density will be plotted.}

\item{sim.Y}{(default to NULL) Second sample from which the density will be plotted.}

\item{user.bounds}{(default to NULL) Bounds to limit the range of x-axis when plotting.}

\item{support}{Support of the distributions, to know whether density plot or histogram should be displayed.}

\item{case}{Used for titles.}
}
\value{
a plot with the densities of the samples provided as inputs.
}
\description{
Plot the density of the sample(s) with optional arguments to improve the visualization.
}
\examples{
comp.dist <- list(f1 = 'norm', g1 = 'norm',
                  f2 = 'norm', g2 = 'norm')
comp.param <- list(f1 = list(mean = 3, sd = 0.5), g1 = list(mean = 0, sd = 1),
                   f2 = list(mean = -2, sd = 0.8), g2 = list(mean = 2, sd = 0.9))
sim.X <- rsimmix(n=2000, unknownComp_weight = 0.7, comp.dist = list(comp.dist$f1,comp.dist$g1),
                 comp.param = list(comp.param$f1,comp.param$g1))
sim.Y <- rsimmix(n=2000, unknownComp_weight = 0.4, comp.dist = list(comp.dist$f2,comp.dist$g2),
                 comp.param = list(comp.param$f2,comp.param$g2))
plot_admix(sim.X[['mixt.data']], sim.Y[['mixt.data']],
           user.bounds = c(-6,6), support = 'continuous')

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
