% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpAdm.R
\name{qpAdm_rotation}
\alias{qpAdm_rotation}
\title{Fit qpAdm models based on the rotation strategy described in
Harney et al. 2020 (bioRxiv)}
\usage{
qpAdm_rotation(
  data,
  target,
  candidates,
  minimize = TRUE,
  nsources = 2,
  ncores = 1,
  fulloutput = FALSE
)
}
\arguments{
\item{data}{EIGENSTRAT dataset}

\item{target}{Target population that is modeled as admixed}

\item{candidates}{Potential candidates for sources and outgroups}

\item{minimize}{Test also all possible subsets of outgroups? (default TRUE)}

\item{nsources}{Number of sources to pull from the candidates}

\item{ncores}{Number of CPU cores to utilize for model fitting}

\item{fulloutput}{Report also 'ranks' and 'subsets' analysis from
qpAdm in addition to the admixture proportions results? (default FALSE)}
}
\value{
qpAdm list with proportions, ranks and subsets elements (as
    with a traditional qpAdm run) or just the proportions
    (determined by the value of the 'fulloutput' argument)
}
\description{
Fit qpAdm models based on the rotation strategy described in
Harney et al. 2020 (bioRxiv)
}
\examples{
\dontrun{# download an example genomic data set and prepare it for analysis
snps <- eigenstrat(download_data(dirname = tempdir()))

# find the set of most likely two-source qpAdm models of
# a French individual - produce only the 'proportions'
# qpAdm summary
models <- qpAdm_rotation(
    data = snps,
    target = "French",
    candidates = c("Dinka", "Mbuti", "Yoruba", "Vindija",
                   "Altai", "Denisova", "Chimp"),
    minimize = TRUE,
    nsources = 2,
    ncores = 2,
    fulloutput = FALSE
)
}

}
