% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reportsuites.R
\name{aw_get_reportsuites}
\alias{aw_get_reportsuites}
\title{Get list of report suites}
\usage{
aw_get_reportsuites(
  company_id = Sys.getenv("AW_COMPANY_ID"),
  rsids = "",
  rsidContains = "",
  limit = 10,
  page = 0,
  expansion = NA,
  debug = FALSE
)
}
\arguments{
\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link{get_me}} to get a list of available \code{company_id} values.}

\item{rsids}{Filter the results to include one or more specific report suites. Specify multiple RSIDs as
a vector (i.e., "\verb{rsids = c("rsid_1", rsid_2",...rsid_n")}").}

\item{rsidContains}{Filter the results list to only include suites that contain the specified string
within the RSID. This is case-insensitive and is a simple, single string match.}

\item{limit}{The number of results to return per page. This argument works in conjunction with the
\code{page} argument. The default is 10.}

\item{page}{The "page" of results to display. This works in conjunction with the \code{limit} argument and is
zero-based. For instance, if \code{limit = 20} and \code{page = 1}, the results returned would be 21 through 40.}

\item{expansion}{Additional segment metadata fields to include in the results: \code{name}, \code{parentRsid},
\code{currency}, \code{calendarType}, \code{timezoneZoneinfo}. This argument takes a single value (e.g., \code{expansion = "name"})
or a vector of values (e.g., \code{expansion = c("name", "currency")}).}

\item{debug}{Include the output and input of the api call in the console for debugging. Default is FALSE}
}
\value{
A data frame of report suites and their meta data.
}
\description{
Retrieve a list of report suites and meta data about each one.
}
