% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freeform_segments.R
\name{aw_segment_table}
\alias{aw_segment_table}
\title{Get a segment-row freeform table}
\usage{
aw_segment_table(
  company_id = Sys.getenv("AW_COMPANY_ID"),
  rsid = Sys.getenv("AW_REPORTSUITE_ID"),
  segmentRsids,
  date_range = c(Sys.Date() - 30, Sys.Date() - 1),
  metrics = c("visits", "visitors"),
  globalSegment = NULL,
  segmentIds = NULL,
  debug = FALSE
)
}
\arguments{
\item{company_id}{Company ID}

\item{rsid}{Report suite ID for the data pull}

\item{segmentRsids}{Deprecated.}

\item{date_range}{Date range}

\item{metrics}{Metrics to request for each segment}

\item{globalSegment}{One or more segments to apply globally over all other
segments}

\item{segmentIds}{One or more segments that will compose the rows of the
table}

\item{debug}{Logical, whether to make verbose requests to the API and view
the whole exchange}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble()}} of segments and metrics. Rows are returned with
segments in the order they were requested, not by metric sorting.
}
\description{
This is the equivalent of a freeform table with segments as the row
components. This type of table offers a few components that \code{aw_freeform_table}
does not. For example, this function does not require (or allow) dimensions
to be included in the breakdown. Segment IDs are automatically translated
into their human-readable names.
}
\details{
This is a specialized function.
To see segments broken down by dimensions, we recommend making multiple
requests to \code{aw_freeform_table} with different global segments applied, and
then row-binding them together yourself.

Unlike \code{aw_freeform_table}, this function automatically handles the 10-metric
restriction imposed by the API.
\subsection{Efficiency}{

In short, segments are cheap, metrics are expensive. Adding 1 metric is the
equivalent of adding 10 segments, judging by the number of requests necessary
to collect the data.
}

\subsection{Stacking segments}{

The function does not currently support segment breakdowns, but you can
stack segments by applying a global segment to your query.
}
}
\seealso{
\code{\link[=aw_freeform_table]{aw_freeform_table()}}
}
