% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scores.R, R/AffineScoreFunction.R
\docType{methods}
\name{score-arithmetic}
\alias{score-arithmetic}
\alias{+,ConditionalScore,numeric-method}
\alias{+,numeric,ConditionalScore-method}
\alias{+,ConditionalScore,ConditionalScore-method}
\alias{*,ConditionalScore,numeric-method}
\alias{*,numeric,ConditionalScore-method}
\alias{+,UnconditionalScore,numeric-method}
\alias{+,numeric,UnconditionalScore-method}
\alias{+,UnconditionalScore,UnconditionalScore-method}
\alias{*,UnconditionalScore,numeric-method}
\alias{*,numeric,UnconditionalScore-method}
\alias{+,AffineUnconditionalScore,UnconditionalScore-method}
\alias{+,UnconditionalScore,AffineUnconditionalScore-method}
\alias{+,AffineUnconditionalScore,numeric-method}
\alias{+,numeric,AffineUnconditionalScore-method}
\alias{+,AffineUnconditionalScore,AffineUnconditionalScore-method}
\alias{*,AffineUnconditionalScore,numeric-method}
\alias{*,numeric,AffineUnconditionalScore-method}
\alias{+,AffineConditionalScore,ConditionalScore-method}
\alias{+,ConditionalScore,AffineConditionalScore-method}
\alias{+,AffineConditionalScore,numeric-method}
\alias{+,numeric,AffineConditionalScore-method}
\alias{+,AffineConditionalScore,AffineConditionalScore-method}
\alias{*,AffineConditionalScore,numeric-method}
\alias{*,numeric,AffineConditionalScore-method}
\title{Score arithmetic}
\usage{
\S4method{+}{ConditionalScore,numeric}(e1, e2)

\S4method{+}{numeric,ConditionalScore}(e1, e2)

\S4method{+}{ConditionalScore,ConditionalScore}(e1, e2)

\S4method{*}{ConditionalScore,numeric}(e1, e2)

\S4method{*}{numeric,ConditionalScore}(e1, e2)

\S4method{+}{UnconditionalScore,numeric}(e1, e2)

\S4method{+}{numeric,UnconditionalScore}(e1, e2)

\S4method{+}{UnconditionalScore,UnconditionalScore}(e1, e2)

\S4method{*}{UnconditionalScore,numeric}(e1, e2)

\S4method{*}{numeric,UnconditionalScore}(e1, e2)

\S4method{+}{AffineUnconditionalScore,UnconditionalScore}(e1, e2)

\S4method{+}{UnconditionalScore,AffineUnconditionalScore}(e1, e2)

\S4method{+}{AffineUnconditionalScore,numeric}(e1, e2)

\S4method{+}{numeric,AffineUnconditionalScore}(e1, e2)

\S4method{+}{AffineUnconditionalScore,AffineUnconditionalScore}(e1, e2)

\S4method{*}{AffineUnconditionalScore,numeric}(e1, e2)

\S4method{*}{numeric,AffineUnconditionalScore}(e1, e2)

\S4method{+}{AffineConditionalScore,ConditionalScore}(e1, e2)

\S4method{+}{ConditionalScore,AffineConditionalScore}(e1, e2)

\S4method{+}{AffineConditionalScore,numeric}(e1, e2)

\S4method{+}{numeric,AffineConditionalScore}(e1, e2)

\S4method{+}{AffineConditionalScore,AffineConditionalScore}(e1, e2)

\S4method{*}{AffineConditionalScore,numeric}(e1, e2)

\S4method{*}{numeric,AffineConditionalScore}(e1, e2)
}
\arguments{
\item{e1}{first summand / factor}

\item{e2}{second summand / factor}
}
\description{
To facilitate working with simple weighted sums of scores,
\code{\link{adoptr}} supports some basic arithmetic operations on score objects
(both conditional and unconditional ones).
Scores can be scalar-multiplied by a constant and added to produce new
scores.
Conditional and unconditional scores cannot be mixed.
}
\examples{
design <- TwoStageDesign(
  n1    = 25,
  c1f   = 0,
  c1e   = 2.5,
  n2    = 50,
  c2    = 1.96,
  order = 7L
)
ess <- expected(ConditionalSampleSize(Normal(), PointMassPrior(.4, 1.0)))
power <- expected(ConditionalPower(Normal(), PointMassPrior(.4, 1.0)))
evaluate(ess + 50*power, design)


}
