% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_growth_rate.R
\name{fit_growth_rate}
\alias{fit_growth_rate}
\title{Fit a growth rate model to time series observations.}
\usage{
fit_growth_rate(
  observations,
  level = 0.95,
  family = c("poisson", "quasipoisson")
)
}
\arguments{
\item{observations}{A numeric vector containing the time series
observations.}

\item{level}{The confidence level for parameter estimates, a numeric
value between 0 and 1.}

\item{family}{A character string specifying the family for modeling.
Choose between "poisson," or "quasipoisson".}
}
\value{
A list containing:
\itemize{
\item 'fit': The fitted growth rate model.
\item 'estimate': A numeric vector with parameter estimates, including
the growth rate and its confidence interval.
\item 'level': The confidence level used for estimating parameter
confidence intervals.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function fits a growth rate model to time series observations and
provides parameter estimates along with confidence intervals.
}
\examples{
# Fit a growth rate model to a time series of counts
# (e.g., population growth)
data <- c(100, 120, 150, 180, 220, 270)
growth_rate_model <- fit_growth_rate(
  observations = data,
  level = 0.95,
  family = "poisson"
)

# Print the estimated growth rate and confidence interval
print(growth_rate_model$estimate)

}
