% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reaggregate_interval_rates.R
\name{reaggregate_interval_rates}
\alias{reaggregate_interval_rates}
\title{Reaggregate rates across intervals}
\usage{
reaggregate_interval_rates(
  lower_bounds,
  upper_bounds = NULL,
  rates,
  breaks,
  weights = NULL
)
}
\arguments{
\item{lower_bounds, upper_bounds}{\verb{[integerish]}.

A pair of vectors representing the bounds of the current intervals.

If \code{upper_bounds} is NULL, it will be automatically set to
\code{c(lower_bounds[-1L], Inf)}.

\code{lower_bounds} must be strictly less than \code{upper_bounds} and greater than or
equal to zero.

Missing (NA) bounds are not permitted.

Double vectors will be coerced to integer.}

\item{rates}{\verb{[numeric]}.

Vector of counts to be averaged.}

\item{breaks}{\verb{[numeric]}.

1 or more non-negative cut points in increasing (strictly) order.

These correspond to the left hand side of the desired intervals (e.g. the
closed side of [x, y).

Double values are coerced to integer prior to categorisation.}

\item{weights}{\verb{[numeric]}

Population weightings to apply for individual years.

If \code{NULL} (default) weights will be allocated proportional to the interval
size.

If specified, must be of length most 2000 and represent weights in the
range 0:1999.

\code{weights} of length less than 2000 will be padded with 0.}
}
\value{
A data frame with 4 entries; \code{interval}, \code{lower_bound}, \code{upper_bound} and an
associated \code{count}.
}
\description{
\code{reaggregate_interval_rates()} enables the reweighting of interval rates in
to different intervals ranges. It first replicates the rates of a given
age interval into the individual years of said interval. These are then
aggregated allowing for a user specified weight vector.
}
\examples{
reaggregate_interval_rates(
  lower_bounds = c(0, 5, 13),
  upper_bounds= c(5, 15, 100),
  rates = c(1, 0.1, 0.01),
  breaks = c(0, 1, 9, 15),
  weights = round(runif(70, 10, 30))
)

reaggregate_interval_rates(
  lower_bounds = c(0, 5, 13),
  rates = c(1, 0.1, 0.01),
  breaks = c(0, 1, 9, 15),
  weights = round(runif(70, 10, 30))
)


}
