% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{interpolate_marginal_posterior}
\alias{interpolate_marginal_posterior}
\title{Interpolate the Marginal Posterior}
\usage{
interpolate_marginal_posterior(
  margpost,
  method = c("auto", "polynomial", "spline")
)
}
\arguments{
\item{margpost}{The output of \code{aghq::marginal_posterior}. See the documentation for that function.}

\item{method}{The method to use. Default is a \code{k} point polynomial interpolant using \code{polynom::poly.calc()}.
This has been observed to result in unstable behaviour for larger numbers of quadrature points \code{k},
which is of course undesirable. If \code{k > 3}, you can set \code{method = 'spline'} to use \code{splines::interpSpline()} instead,
which uses cubic B-Splines. These should always be better than a straight polynomial, except don't work
when \code{k < 4} which is why they aren't the default. If you try and set \code{method = 'spline'} with
\code{k < 4} it will be changed back to polynomial, with a warning.}
}
\value{
A function of \code{theta} which computes the log interpolated normalized marginal posterior.
}
\description{
Build a Lagrange polynomial interpolant of the marginal posterior, for plotting
and for computing quantiles.
}
\seealso{
Other summaries: 
\code{\link{compute_moment}()},
\code{\link{compute_pdf_and_cdf}()},
\code{\link{compute_quantiles}()},
\code{\link{marginal_posterior}()}
}
\concept{summaries}
