% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{validate_moment}
\alias{validate_moment}
\alias{validate_moment.aghqmoment}
\alias{validate_moment.list}
\alias{validate_moment.function}
\alias{validate_moment.character}
\alias{validate_moment.default}
\title{Validate a moment function object}
\usage{
validate_moment(...)

\method{validate_moment}{aghqmoment}(moment, checkpositive = FALSE, ...)

\method{validate_moment}{list}(moment, checkpositive = FALSE, ...)

\method{validate_moment}{`function`}(moment, checkpositive = FALSE, ...)

\method{validate_moment}{character}(moment, checkpositive = FALSE, ...)

\method{validate_moment}{default}(moment, ...)
}
\arguments{
\item{...}{Used to pass arguments to methods.}

\item{moment}{An object to check if it is a valid moment function or not. Can be an object of class \code{aghqmoment} returned by \code{aghq::make_moment_function()},
or any object that can be passed to \code{aghq::make_moment_function()}.}

\item{checkpositive}{Default \code{FALSE}, do not check that \code{gg$fn(theta) > 0}. Otherwise,
a vector of values for which to perform that check. No default values are provided, since \code{validate_moment}
has no way of determining the domain and range of \code{gg$fn}. This argument is
used internally in \code{aghq} package functions, with cleverly chosen check values.}
}
\value{
\code{TRUE} if the function runs to completion without throwing an error.
}
\description{
Routine for checking whether a given moment function object is valid.
}
\details{
This function checks that:
\itemize{
\item{The supplied object contains elements \code{fn}, \code{gr}, and \code{he}, and that they are all functions,}
\item{If \code{checkpositive} is a vector of numbers, then it checks that \code{gg$fn(checkpositive)} is not \code{-Inf}, \code{NA}, or \code{NaN}. (It actually uses \code{is.infinite} for the first.)}
}
In addition, if a \code{list} is provided, the function first checks that it contains the right elements,
then passes it to \code{make_moment_function}, then checks that. If a \code{function} or a \code{character} is provided,
it checks that \code{match.fun} works, and returns any errors or warnings from doing so in a clear way.

This function throws an informative error messages when checks don't pass or themselves throw errors.
}
\examples{

mom1 <- make_moment_function(exp)
mom2 <- make_moment_function('exp')
mom3 <- make_moment_function(list(fn=function(x) x,gr=function(x) 1,he = function(x) 0))
validate_moment(mom1)
validate_moment(mom2)
validate_moment(mom3)
\dontrun{
mombad1 <- list(exp,exp,exp) # No names
mombad2 <- list('exp','exp','exp') # List of not functions
mombad3 <- make_moment_function(function(x) -exp(x)) # Not positive
validate_moment(mombad1)
validate_moment(mombad2)
validate_moment(mombad3)
}
}
\seealso{
Other moments: 
\code{\link{make_moment_function}()}
}
\concept{moments}
