% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataFromGrid.R
\name{dataFromGrid}
\alias{dataFromGrid}
\title{Extract data from a gridded dataset}
\usage{
dataFromGrid(grid, varname, lon, lat, times = FALSE)
}
\arguments{
\item{grid}{a RasterBrick or RasterStack object or a path to a NetCDF file.}

\item{varname}{a character string specifying the name of the variable to extract in NetCDF file.}

\item{lon}{numeric vector with longitude(s) of target location(s).}

\item{lat}{numeric vector with latitude(s) of target location(s).}

\item{times}{logical. If TRUE, time dimension will be extracted from data and the returned values will be in form of a zoo object. Only works for NetCDF and RasterBrick.}
}
\value{
A matrix with same columns as pairs of coordinates defined in lon and lat arguments. If times is TRUE, the matrix will be a zoo object.
}
\description{
This function extracts data from a gridded dataset based on given coordinates.
}
\details{
The argument time searches the time dimension and its units in the gridded dataset (NetCDF or RasterBrick). If it can't be found, only the data will be returned.

Arguments lon and lat define the coordinates that must be in the same projection as the gridded dataset. If there is no spatial coincidence, returned object will be empty.
}
\examples{

\donttest{
 dataFromGrid(grid = "../data/tmax.nc",
                 varname = 'tn',
                 lon = c(41.39, 42),
                 lat = c(2.17, 2.5),
                 times = FALSE)
}
}
