% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pentadProbs.R
\name{pentadProbs}
\alias{pentadProbs}
\title{Pentadic probabilities}
\usage{
pentadProbs(
  mx,
  mn,
  temp_dates,
  out = NULL,
  min_abs = -20,
  max_abs = 44,
  plot_years = NULL,
  show_legend = TRUE
)
}
\arguments{
\item{mx}{vector containing the daily maximum temperature series.}

\item{mn}{same as mx but with daily minimum temperature series.}

\item{temp_dates}{sequence of daily dates coinciding with temperature data series.}

\item{out}{system path to the generated output file ('.pdf').}

\item{min_abs}{minimum absolute temperature used as threshold to plot data.}

\item{max_abs}{same as min_abs but with maximum absolute temperature.}

\item{plot_years}{numeric vector indicating the frequencies of individual years to plot over the averages.}

\item{show_legend}{logical value indicating wether legend will be shown or not.}
}
\value{
If the output path is defined, a pdf file is created.
}
\description{
This function calculates the probability od occurrence of a temperature range in a five-day row (pentad).
}
\details{
The numer of individual years to plot over the average frequencies is unlimited. However, it is recommended to add only a few due to the difficult of reading a lot of information in the same plot.

The colors of the individual years are random, so it is possible to get different colors for same years in two runs of same plot.
}
\examples{


# basic plot with legend
 pentadProbs(mx = daily_tmax, mn = daily_tmin,
              temp_dates = seq.Date(as.Date('1981-01-01'),
              as.Date('2010-12-31'), by ='day'),
              out = NULL, min_abs = -20, max_abs = 44,
              plot_years = NULL, show_legend = TRUE)

# years 1981 and 2009 are plotted over the average frequencies
 pentadProbs(mx = daily_tmax, mn = daily_tmin,
              temp_dates = seq.Date(as.Date('1981-01-01'),
              as.Date('2010-12-31'), by ='day'),
              out = NULL, min_abs = -20, max_abs = 44,
              plot_years = c(1981, 2009), show_legend = TRUE)

}
