% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Calibration.GRiwrmInputsModel.R,
%   R/Calibration.InputsModel.R, R/Calibration.R
\name{Calibration.GRiwrmInputsModel}
\alias{Calibration.GRiwrmInputsModel}
\alias{Calibration.InputsModel}
\alias{Calibration}
\title{Calibration of the parameters of one catchment or a network of sub-catchments}
\usage{
\method{Calibration}{GRiwrmInputsModel}(
  InputsModel,
  RunOptions,
  InputsCrit,
  CalibOptions,
  useUpstreamQsim = TRUE,
  ...
)

\method{Calibration}{InputsModel}(InputsModel, ...)

Calibration(InputsModel, ...)
}
\arguments{
\item{InputsModel}{[object of class \emph{InputsModel} or \emph{GRiwrmInputsModel}] see \link{CreateInputsModel}}

\item{RunOptions}{[object of class \emph{RunOptions} or \emph{GRiwrmRunOptions}] see \link{CreateRunOptions}}

\item{InputsCrit}{[object of class \emph{InputsCrit} or \emph{GRiwrmInputsCrit}] see \link{CreateInputsCrit}}

\item{CalibOptions}{[object of class \emph{CalibOptions} or \emph{GRiwrmCalibOptions}] see \link{CreateCalibOptions} for details}

\item{useUpstreamQsim}{boolean describing if simulated (\code{TRUE}) or observed (\code{FALSE}) flows are used for calibration. Default is \code{TRUE}}

\item{...}{further arguments passed to \link[airGR:Calibration]{airGR::Calibration}, see details}
}
\value{
Depending on the class of \code{InputsModel} argument (respectively \code{InputsModel} and \code{GRiwrmInputsModel} object), the returned value is respectively:
\itemize{
\item a \code{InputsCrit} object (See \link[airGR:CreateInputsCrit]{airGR::CreateInputsCrit})
\item a \code{GRiwrmInputsCrit} object which is a \link{list} of \code{InputsCrit} objects with one item per modeled sub-catchment
}
}
\description{
Calibration algorithm that optimizes the error criterion selected as objective function using the provided functions.
}
\details{
This function can be used either for a catchment (with an \emph{InputsModel} object) or for a network (with a \emph{GRiwrmInputsModel} object)

Argument classes should be consistent to the usage:
\itemize{
\item a \code{InputsModel} argument of class \emph{InputsModel} must be followed by a \code{RunOptions} argument of class \emph{RunOptions}, a \code{InputsCrit} argument of class \emph{InputsCrit} and a \code{CalibOptions} of class \emph{CalibOptions}
\item 
\itemize{
\item a \code{InputsModel} argument of class \emph{GRiwrmInputsModel} must be followed by a \code{RunOptions} argument of class \emph{GRiwrmRunOptions}, a \code{InputsCrit} argument of class \emph{GRiwrmInputsCrit} and a \code{CalibOptions} of class \emph{GRiwrmCalibOptions}
}
}

See the vignettes for examples.
}
