% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunModel.GR.R
\name{RunModel.GR}
\alias{RunModel.GR}
\title{Run of a rainfall-runoff model on a sub-basin}
\usage{
\method{RunModel}{GR}(x, RunOptions, Param, ...)
}
\arguments{
\item{x}{[object of class \code{InputsModel}] \code{InputsModel} for \link[airGR:RunModel]{airGR::RunModel}}

\item{RunOptions}{[object of class \emph{RunOptions}] see \link[airGR:CreateRunOptions]{airGR::CreateRunOptions} for details}

\item{Param}{\link{numeric} vector of model parameters (See details for SD lag model)}

\item{...}{further arguments passed to or from other methods}
}
\value{
[list] see \code{\link[airGR]{RunModel_GR4J}} or \code{\link[airGR]{RunModel_CemaNeigeGR4J}} for details.

If \code{InputsModel} parameter has been created for using a semi-distributed (SD) lag model (See \code{\link[airGR]{CreateInputsModel}}), the list value contains an extra item named \code{QsimDown} which is a numeric series of simulated discharge [mm/time step] related to the run-off contribution of the downstream sub-catchment.
}
\description{
Function which performs a single model run with the provided function over the selected period.
}
\details{
If \code{InputsModel} parameter has been created for using a semi-distributed (SD) lag model (See \code{\link[airGR]{CreateInputsModel}}), the first item of \code{Param} parameter should contain a constant lag parameter expressed as a velocity in m/s, parameters for the hydrological model are then shift one position to the right.
}
