% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_station_data.R
\name{get_station_month_data}
\alias{get_station_month_data}
\title{Download monthly pollution data}
\usage{
get_station_month_data(criterion, pollutant, year, month)
}
\arguments{
\item{criterion}{Type of data to download.
\itemize{
 \item{"HORARIOS"}{ - Hourly data}
 \item{"MAXIMOS""}{ - Daily maximums}
 \item{"MINIMOS"}{ - Daily minimums}
}}

\item{pollutant}{The type of pollutant to download.
\itemize{
 \item{"SO2"}{ - Sulfur Dioxide (parts per billion)}
 \item{"CO"}{ - Carbon Monoxide (parts per million)}
 \item{"NOX"}{ - Nitrogen Oxides (parts per billion)}
 \item{"NO2"}{ - Nitrogen Dioxide (parts per billion)}
 \item{"NO"}{ - Nitric Oxide (parts per billion)}
 \item{"O3"}{ - Ozone (parts per billion)}
 \item{"PM10"}{ - Particulate matter 10 micrometers or less
 (micrograms per cubic meter)}
 \item{"PM25"}{ - Particulate matter 2.5 micrometers or less
 (micrograms per cubic meter)}
 \item{"WSP"}{ - Wind velocity (meters per second)}
 \item{"WDR"}{ - Wind direction (degrees)}
 \item{"TMP"}{ - Temperature (degrees Celsius)}
 \item{"RH"}{ - Relative humidity (percentage)}
}}

\item{year}{an integer indicating the year for which to download data
(the earliest possible value is 1986)}

\item{month}{month number to download}
}
\value{
A data.frame with pollution data, the hours correspond to the
\emph{Etc/GMT+6} timezone, with no daylight saving time
}
\description{
Retrieve hourly averages, daily maximums, or daily minimums of pollution data
in the original units, by station, from the air quality server at
\href{http://www.aire.cdmx.gob.mx/estadisticas-consultas/concentraciones/index.php}{Consulta de Concentraciones}
}
\details{
Temperature (TMP) data was rounded to the nearest integer, but the
\code{\link{get_station_data}} function allows you to download data accurate
to one decimal point in some cases (i.e. for old data).
}
\section{Warning}{

The data for the current month is in the process of being validated
}

\examples{
\dontrun{
## Download daily hourly PM10 data (particulate matter 10 micrometers or
## less in diameter) from March 2016
df_pm10 <- get_station_month_data("HORARIOS", "PM10", 2016, 3)
head(df_pm10)

## Download daily hourly O3 data from October 2017
df_o3 <- get_station_month_data("HORARIOS", "O3", 2018, 1)
## Convert to local Mexico City time
df_o3$mxc_time <- format(as.POSIXct(paste0(df_o3$date,
                                           " ",
                                           df_o3$hour, ":00"),
                                    tz = "Etc/GMT+6"),
                         tz = "America/Mexico_City")
head(df_o3)
}
}
\seealso{
\code{\link{stations}} for a data.frame with the location and names
of all pollution measuring stations

Other raw data functions: \code{\link{get_station_data}}
}
\concept{raw data functions}
