% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_archives.R
\name{download_deposition}
\alias{download_deposition}
\title{Download Acid Rain Measurements Archives}
\usage{
download_deposition(deposition, type)
}
\arguments{
\item{deposition}{type of deposition to download
\itemize{
 \item{"TOTAL"}{ - Total deposition (1988-2000)}
 \item{"HUMEDO"}{ - Wet and dry deposition (1997-)}
}}

\item{type}{type of ion measurement
\itemize{
 \item{"DEPOSITO"}{ -  ion quantity deposition}
 \item{"CONCENTRACION"}{ - ion concentration}
}}
}
\value{
A data.frame with deposition data.
}
\description{
Download data on rainfall samples collected weekly during the rainy season, available at
\href{http://www.aire.cdmx.gob.mx/default.php?opc=\%27aKBhnmE=\%27&r=aHR0cDovLzE0OC4yNDMuMjMyLjExMjo4MDgwL29wZW5kYXRhL3JlZGRhL2RlcG9zaXRvLmNzdg==}{Depósito}
and
\href{http://www.aire.cdmx.gob.mx/default.php?opc=\%27aKBhnmE=\%27&r=aHR0cDovLzE0OC4yNDMuMjMyLjExMjo4MDgwL29wZW5kYXRhL3JlZGRhL2RlcG9zaXRvVC5jc3Y=}{Depósito}
}
\examples{
\dontrun{
## Download rainfall in mm
df <- download_deposition(deposition = "HUMEDO", type = "CONCENTRACION") \%>\%
        filter(pollutant == "PP")
head(df)
}
}
