% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R
\name{validate_airr}
\alias{validate_airr}
\title{Validate AIRR data}
\usage{
validate_airr(data, schema = RearrangementSchema)
}
\arguments{
\item{data}{data.frame to validate.}

\item{schema}{\code{Schema} object defining the data standard.}
}
\value{
Returns \code{TRUE} if the input \code{data} is compliant and
          \code{FALSE} if not.
}
\description{
\code{validate_airr} validates compliance of the contents of a data.frame 
to the AIRR data standards.
}
\examples{
# Get path to the rearrangement-example file
file <- system.file("extdata", "rearrangement-example.tsv.gz", package="airr")

# Load data file
df <- read_rearrangement(file)

# Validate a data.frame against the Rearrangement schema
validate_airr(df, schema=RearrangementSchema)

}
