% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\name{plotDiversityTest}
\alias{plotDiversityTest}
\title{Plot the results of TestDiversity}
\usage{
plotDiversityTest(data, colors = NULL, main_title = "Diversity",
  legend_title = "Group", log_d = FALSE, annotate = c("none",
  "depth"), silent = FALSE, ...)
}
\arguments{
\item{data}{\link{DiversityTest} object returned by 
\link{testDiversity}.}

\item{colors}{named character vector whose names are values in the 
\code{group} column of the \code{data} slot of \code{data},
and whose values are colors to assign to those group names.}

\item{main_title}{string specifying the plot title.}

\item{legend_title}{string specifying the legend title.}

\item{log_d}{if \code{TRUE} then plot the diversity scores \eqn{D} 
on a log scale; if \code{FALSE} plot on a linear scale.}

\item{annotate}{string defining whether to added values to the group labels 
of the legend. When \code{"none"} (default) is specified no
annotations are added. Specifying (\code{"depth"}) adds 
sequence counts to the labels.}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A \code{ggplot} object defining the plot.
}
\description{
\code{plotDiversityTest} plots a \code{DiversityTest} object as the mean
with a line range indicating plus/minus one standard deviation.
}
\examples{
# All groups pass default minimum sampling threshold of 10 sequences
div <- testDiversity(ExampleDb, "SAMPLE", q=0, nboot=100)
plotDiversityTest(div, legend_title="Sample")

}
\seealso{
See \link{testDiversity} for generating \link{DiversityTest}
          objects for input. Plotting is performed with \link{ggplot}.
}
