% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AminoAcids.R
\name{polar}
\alias{polar}
\title{Calculates the average polarity of amino acid sequences}
\usage{
polar(seq, polarity = NULL)
}
\arguments{
\item{seq}{vector of strings containing amino acid sequences.}

\item{polarity}{named numerical vector defining polarity scores for 
each amino acid, where names are single-letter amino acid 
character codes. If \code{NULL}, then the Grantham, 1974
scale is used.}
}
\value{
A vector of bulkiness scores for the sequence(s).
}
\description{
\code{polar} calculates the average polarity score of amino acid sequences. 
Non-informative positions are excluded, where non-informative is defined as any 
character in \code{c("X", "-", ".", "*")}.
}
\examples{
# Default scale
seq <- c("CARDRSTPWRRGIASTTVRTSW", "XXTQMYVRT")
polar(seq)

# Use the Zimmerman et al, 1968 polarity scale from the seqinr package
library(seqinr)
data(aaindex)
x <- aaindex[["ZIMJ680103"]]$I
# Rename the score vector to use single-letter codes
names(x) <- translateStrings(names(x), ABBREV_AA)
# Calculate polarity
polar(seq, polarity=x)

}
\references{
\enumerate{
  \item  Grantham R. Amino acid difference formula to help explain protein evolution. 
           Science 185, 862-864 (1974).
}
}
\seealso{
For additional size related indices see \code{\link[seqinr]{aaindex}}.
}

