% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFile.r
\docType{class}
\name{AlgorithmiaDataFile-class}
\alias{AlgorithmiaDataFile}
\alias{AlgorithmiaDataFile-class}
\title{DataFile object to interact with files. Supports Algorithmia data
files, S3, Dropbox and more coming soon!
To create one, call: `client$file("file_path")`}
\description{
DataFile object to interact with files. Supports Algorithmia data
files, S3, Dropbox and more coming soon!
To create one, call: `client$file("file_path")`
}
\section{Fields}{

\describe{
\item{\code{client}}{Reference to the AlgorithmiaClient object that has the credentials
necessary to make API calls.}

\item{\code{dataFileUrl}}{Url to access the file.}

\item{\code{last_modified}}{A timestamp for the last modified time. Only gets set when setAttributes is called.}

\item{\code{size}}{Size (in bytes) of the file. Only gets set when setAttributes is called.}
}}
\section{Methods}{

\describe{
\item{\code{delete()}}{Deletes the file.}

\item{\code{exists()}}{Returns TRUE if this file exists. FALSE, if it does not.}

\item{\code{getFile()}}{Copies the file to a tempfile and returns the path to that file.}

\item{\code{getJson()}}{Returns the contents of the file after it has been JSON decoded.}

\item{\code{getName()}}{Returns the name of the file without the parent directory path.}

\item{\code{getRaw()}}{Returns the raw contents of the file.}

\item{\code{getString()}}{Returns the contents of the file as a string.}

\item{\code{put(data)}}{Writes the file with the current data passed in.}

\item{\code{putFile(fileName)}}{Takes a local file path and writes its contents to this file.}

\item{\code{putJson(data)}}{Encodes the data to a JSON object and writes that to the file.}

\item{\code{setAttributes(attributes)}}{Sets the last_modified time and size (in bytes) of the file.}
}}

