% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignfigR.R
\name{extract_subalign}
\alias{extract_subalign}
\title{Extract subset of sequence alignment}
\usage{
extract_subalign(seqs, plot_step = 1, tlist = c(), clist = c(),
  texcl = FALSE, cexcl = FALSE)
}
\arguments{
\item{seqs}{Sequence list, as parsed by the function `read_alignment`}

\item{plot_step}{Step size for alignment block. Default, 1.}

\item{tlist}{Array of taxa intended to restrict figure to or to exclude from figure.}

\item{clist}{Array of columns intended to restrict figure to or to exclude from figure.}

\item{texcl}{Boolean indicating if taxa in tlist should be excluded. Default, False}

\item{cexcl}{Boolean indicating if columns in clist should be excluded. Default, False}
}
\value{
plot_frame, a data frame to be plotted
}
\description{
This function builds a data frame to plot an alignment from a specified subset of the full alignment.
}
\examples{
fasta_file <- system.file("extdata", "example.fasta", package = "alignfigR")
plot_frame <- read_alignment(file = fasta_file)
subset_seq_list <- extract_subalign(plot_frame, tlist = c("Cow", "Human", "Whale"), texcl = TRUE)
subset_seq_list <- extract_subalign(plot_frame, clist = 1:25)
}
