% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/integrate.R
\docType{methods}
\name{integrate_rectangle}
\alias{integrate_rectangle}
\alias{integrate_rectangle-method}
\alias{integrate_rectangle,numeric,numeric-method}
\alias{integrate_rectangle,ANY,missing-method}
\title{Rectangle Rule}
\usage{
integrate_rectangle(x, y, ...)

\S4method{integrate_rectangle}{numeric,numeric}(x, y, right = FALSE)

\S4method{integrate_rectangle}{ANY,missing}(x, right = FALSE)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{right}{A \code{\link{logical}} scalar: should the right rule be used instead of
the left rule?}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Approximates the definite integral by using the rectangle rule.
}
\examples{
## Calculate the area under the sine curve from 0 to pi
# integrate(f = function(x) x^3, lower = 0, upper = 2)
x <- seq(0, 2, len = 101)
y <- x^3

plot(x, y, type = "l")

integrate_rectangle(x, y, right = FALSE) # 3.9204
integrate_rectangle(x, y, right = TRUE) # 4.0804
integrate_trapezoid(x, y) # 4.0004
}
\seealso{
Other integration methods: 
\code{\link{integrate_trapezoid}()}
}
\author{
N. Frerebeau
}
\concept{integration methods}
