% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_past_sales_data.R
\name{get_past_sales_data}
\alias{get_past_sales_data}
\title{Extract Allhomes past sales data for a/multiple suburb(s) and year(s).}
\usage{
get_past_sales_data(suburb, year, quiet = FALSE)
}
\arguments{
\item{suburb}{A \code{character} vector denoting a/multiple suburbs. Format for
every entry must be "suburb_name, state/territory_abbreviation", e.g.
"Balmain, ACT".}

\item{year}{An \code{integer} vector denoting the year(s).}

\item{quiet}{If \code{TRUE} then messages are suppressed. Currently ignored.}
}
\value{
A \code{tibble}.
}
\description{
Extract Allhomes past sales data for a/multiple suburb(s) and year(s).
}
\examples{
\donttest{
get_past_sales_data(
    c("Balmain, NSW", "Acton, ACT", "Nowra, NSW"),
    2020L:2021L)
}
}
