% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/alm_ids.R
\name{alm_ids}
\alias{alm_ids}
\title{Retrieve PLoS article-level metrics (ALM).}
\usage{
alm_ids(doi = NULL, pmid = NULL, pmcid = NULL, wos = NULL, scp = NULL,
  url = NULL, info = "totals", source_id = NULL, publisher_id = NULL,
  key = NULL, total_details = FALSE, sum_metrics = NULL, sleep = 0,
  api_url = "http://alm.plos.org/api/v5/articles", ...)
}
\arguments{
\item{doi}{(character) Digital object identifier for an article in PLoS Journals}

\item{pmid}{(numeric) PubMed object identifier}

\item{pmcid}{(numeric) PubMed Central object identifier}

\item{wos}{(character) Web of Science identifier}

\item{scp}{(character) Scopus identifier}

\item{url}{(character) Canonical URL. This is a URL for an object, not the URL for the
Lagotto instance (see api_url)}

\item{info}{One of totals, summary, or detail (default totals + sum_metrics data in a list).
     Not specifying anything (the default) returns data.frame of totals across
     data providers. (character). \code{info='detail'} returns all possible data, including slots
   for info, signposts, totals, and sum_metrics (see the sum_metrics parameter below).
IMPORTANT: note, however, that you can only get by day metrics for articles published since
May 2014.}

\item{source_id}{(character) Name of source to get ALM information for. One source only.
You can get multiple sources via a for loop or lapply-type call.}

\item{publisher_id}{(character) Metrics for articles by a given publisher, using the Crossref
\code{member_id}.}

\item{key}{(character) Your API key, either enter, or loads from .Rprofile. Only required for
PKP source, not the others.}

\item{total_details}{(logical) If FALSE (the default) the standard totals data.frame is
returned; if TRUE, the totals data is in a wide format with more details
about the paper, including publication date, title, etc. If you set this
to TRUE, the output should no longer with with \code{\link{alm_plot}}.}

\item{sum_metrics}{(character) Just like the output you get from setting info='totals', you can
get summary metrics by day (sum_metrics='day'), month (sum_metrics='month'),
or year (sum_metrics='year'). IMPORTANT: note that you can only get by day metrics for
articles published since May 2014.}

\item{sleep}{Set a sleep time (in seconds). Only used for large calls where you may be in danger
of upsetting the server gods, can you say 504 error?}

\item{api_url}{(character) API endpoint, defaults to http://alm.plos.org/api/v5/articles}

\item{...}{Curl options (debugging tools mostly) passed on to \code{\link[httr]{GET}}}
}
\value{
PLoS altmetrics as data.frame's.
}
\description{
This is the main function to search the PLoS ALM (article-level metrics) API.
See details for more information.
}
\details{
You can only supply one of the parmeters doi, pmid, pmcid, wos, scp, or url; and you
must supply one of them. Query for as many articles at a time as you like. Though queries
are broken up in to smaller bits of 50 identifiers at a time. If you supply days, months and/or
year parameters, days takes precedence over months and year.
}
\examples{
\dontrun{
# The default call with either doi, pmid, pmcid, wos, scp, or url without specifying
# an argument for info
alm_ids(doi="10.1371/journal.pone.0029797")

# Details for a single DOI
out <- alm_ids(doi='10.1371/journal.pone.0029797', info='detail')
out
## totals
out$data$info
## history
out$data$sum_metrics

# A single PubMed ID (pmid)
alm_ids(pmid=22590526)

# A single PubMed Central ID (pmcid)
alm_ids(pmcid=212692, info='summary')

# A single Web of Science ID (wos)
alm_ids(wos="000268452400005")

# A single Scopus ID (scp)
alm_ids(scp="68049122102")

# A single Canonical URL (url)
alm_ids(url="http://www.plosmedicine.org/article/info:doi/10.1371/journal.pmed.1000097")

# Provide more than one DOI
dois <- c('10.1371/journal.pone.0001543','10.1371/journal.pone.0040117',
		'10.1371/journal.pone.0029797','10.1371/journal.pone.0039395')
out <- alm_ids(doi=dois)
out$data[[1]] # get data for the first DOI

# Search for DOI's, then feed into alm
library('rplos')
dois <- searchplos(q='evolution', fl='id',
   fq=list('-article_type:correction','doc_type:full'), limit = 250)
out <- alm_ids(doi=dois$data$id)
lapply(out, head)

alm_ids(dois$data$id[1:5], source_id = "facebook")

sources <- c("facebook","twitter","mendeley","reddit","scopus","wikipedia")
lapply(sources, function(x) alm_ids(dois$data$id[1:5], source_id = x))

# Provide more than one pmid
pmids <- c(19300479, 19390606, 19343216)
out <- alm_ids(pmid=pmids)
out$data[[3]] # get data for the third pmid

# Getting data for a specific source_id
alm_ids(doi='10.1371/journal.pone.0035869', source_id='mendeley')
alm_ids(doi='10.1371/journal.pone.0035869', source_id='twitter')
alm_ids(doi='10.1371/journal.pone.0035869', source_id='counter', info='detail')
## fails if more than one source_id given
# alm_ids(doi='10.1371/journal.pone.0035869', source_id=c('twitter','facebook'))

# Get detailed totals output
alm_ids(doi='10.1371/journal.pone.0035869', total_details=TRUE)

# Get summary metrics by day
alm_ids(doi='10.1371/journal.pone.0036240', sum_metrics='day')

# Get summary metrics by month
alm_ids(doi='10.1371/journal.pone.0036240', sum_metrics='month')

# Get summary metrics by year
alm_ids(doi='10.1371/journal.pone.0036240', sum_metrics='year')

# Get data by source_id
alm_ids(source_id='crossref')
alm_ids(source_id='twitter')

# Curl debugging
library('httr')
alm_ids(doi="10.1371/journal.pone.0029797", config=verbose())
dois <- c('10.1371/journal.pone.0001543','10.1371/journal.pone.0040117',
 	'10.1371/journal.pone.0029797','10.1371/journal.pone.0039395')
alm_ids(doi=dois, config=progress())

# Data from other sources
## Crossref article data
### Pass in a different URL - no key needed
api_url <- "http://det.labs.crossref.org/api/v5/articles"
alm_ids(doi='10.1371/journal.pone.0086859', api_url = api_url)
alm_ids(doi='10.11646/zootaxa.3618.1.1', api_url = api_url)
alm_ids(doi='10.1016/j.jep.2013.06.007', api_url = api_url)
alm_ids(doi='10.1111/j.1756-1051.2012.00099.x', api_url = api_url)

## Public Knowledge Project article data
### pass in a different url - an API key needed
api_url <- 'http://pkp-alm.lib.sfu.ca/api/v5/articles'
alm_ids(doi='10.3402/gha.v7.23554', api_url = api_url, key = getOption("pkpalmkey"))

## eLife
### pass in a different url - no key needed
api_url <- 'http://lagotto.svr.elifesciences.org/api/v5/articles'
alm_ids(doi='10.7554/eLife.00471', api_url = api_url)
}
}
\references{
See a tutorial/vignette for alm at
\url{http://ropensci.org/tutorials/alm_tutorial.html}
}
\seealso{
\code{\link{alm_plot}}
}

