% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustments.R
\name{adjustments}
\alias{adjustments}
\alias{adj_following}
\alias{adj_preceding}
\alias{adj_modified_following}
\alias{adj_modified_preceding}
\alias{adj_nearest}
\alias{adj_none}
\title{Date adjustments}
\usage{
adj_following(x, rschedule)

adj_preceding(x, rschedule)

adj_modified_following(x, rschedule)

adj_modified_preceding(x, rschedule)

adj_nearest(x, rschedule)

adj_none(x, rschedule)
}
\arguments{
\item{x}{\verb{[Date]}

A vector of dates.}

\item{rschedule}{\verb{[rschedule]}

An rschedule, such as an rrule or rbundle.}
}
\value{
An adjusted vector of Dates.
}
\description{
This family of \verb{adj_*()} functions encode business logic for common
date adjustments. If \code{x} falls on an event date, it is adjusted according to
the function's adjustment rule. Otherwise it is left untouched.
\itemize{
\item \code{adj_following()}

Choose the first non-event date after \code{x}.
\item \code{adj_preceding()}

Choose the first non-event date before \code{x}.
\item \code{adj_modified_following()}

Choose the first non-event date after \code{x}, unless it falls in a
different month, in which case the first non-event date before \code{x} is
chosen instead.
\item \code{adj_modified_preceding()}

Choose the first non-event date before \code{x}, unless it falls in a
different month, in which case the first non-event date after \code{x} is
chosen instead.
\item \code{adj_nearest()}

Choose the nearest non-event date to \code{x}. If the closest preceding and
following non-event dates are equally far away, the following non-event
date is chosen.
\item \code{adj_none()}

Performs no adjustment and returns \code{x} unchanged.
}
}
\examples{
# A Saturday
x <- as.Date("1970-01-03")

on_weekends <- weekly() \%>\% recur_on_weekends()

# Adjust forward to Monday
adj_following(x, on_weekends)

# Adjust backwards to Friday
adj_preceding(x, on_weekends)

# Adjust to nearest non-event date
adj_nearest(x, on_weekends)
adj_nearest(x + 1, on_weekends)

# Sundays, one of which is at the end of the month
sundays <- as.Date(c("2020-05-24", "2020-05-31"))

# Adjust forward, unless that takes us into a new month, in which case we
# adjust backwards.
adj_modified_following(sundays, on_weekends)

# Saturdays, one of which is at the beginning of the month
saturdays <- as.Date(c("2020-08-01", "2020-08-08"))

# Adjust backwards, unless that takes us into a new month, in which
# case we adjust forwards
adj_modified_preceding(saturdays, on_weekends)
}
