% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFEs.R
\name{getFEs}
\alias{getFEs}
\title{Efficiently recover estimates of the fixed effects after fitting \code{feglm}}
\usage{
getFEs(object, alpha.tol = 1e-08)
}
\arguments{
\item{object}{an object of class \code{"feglm"}.}

\item{alpha.tol}{tolerance level for the stopping condition. The algorithm is stopped in iteration
\eqn{i} if \eqn{||\boldsymbol{\alpha}_{i} - \boldsymbol{\alpha}_{i - 1}||_{2} < 
tol ||\boldsymbol{\alpha}_{i - 1}||_{2}}{||\Delta \alpha|| < tol ||\alpha_old||}.
Default is \code{1.0e-08}.}
}
\value{
The function \code{getFEs} returns a named vector of estimated fixed effects.
}
\description{
Recover estimates of the fixed effects by alternating between the normal equations of the fixed 
effects as shown by Stammann (2018).

\strong{Remark}: The system might not have a unique solution since we do not take collinearity
into account. If the solution is not unique, an estimable function has to be applied to our
solution to get meaningful estimates of the fixed effects. See Gaure (n. d.) for an extensive
treatment of this issue.
}
\references{
Gaure, S. (n. d.). "Multicollinearity, identification, and estimable 
functions". Unpublished.

Stammann, A. (2018). "Fast and Feasible Estimation of Generalized Linear Models with 
High-Dimensional k-way Fixed Effects". ArXiv e-prints.
}
\seealso{
\code{\link{feglm}}
}
