#' Error handling for incorrect object inputs to api.R calls
#'
#' @param object An R object
#' @param type Expected \code{class} of \code{object}
check_class <- function(object, type) {
  error_message <-
    "argument '{class}' must be an object of class 'alteryx_{class}"
  error_message <-
    gsub("\\{class\\}", type, error_message)

  what <- paste0("alteryx_", type)

  if(!inherits(object, what))
    stop(error_message)
}

#' Error handling for non-200 status codes
#'
#' @param response Response generated by a request such as \code{httr::GET}
#' or \code{httr::POST}
check_status <- function(response) {
  status <- httr::status_code(response)

  if(status != "200") {
    content <- httr::content(response)
    if("message" %in% names(content)) {
      stop(paste(status, content$exceptionName, content$message))
      return(response)
    } else {
      stop(paste(status, "Unexpected Response"))
      return(response)
    }
  }

  return(response)
}

#' Check Keys
check_keys <- function() {
  key <- getOption("alteryx_api_key")
  secret <- getOption("alteryx_secret_key")

  if(is.null(key) || is.null(secret))
    stop("'alteryx_api_key' and/or 'alteryx_secret_key' not set as option")

  return(NULL)
}
