% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates_auxiliary.R
\name{calc_return_locs}
\alias{calc_return_locs}
\title{Prepare covariates for return}
\usage{
calc_return_locs(covar, POSIXt = TRUE, geom, crs)
}
\arguments{
\item{covar}{data.frame(1). Calculated covariates \code{data.frame}.}

\item{POSIXt}{logical(1). Should the time values in \code{covar} be of class
\code{POSIXt}? If \code{FALSE}, the time values will be checked for integer class
(year and year-month).}

\item{geom}{logical(1). Should \code{covar} be returned as a
\code{data.frame}? Default is \code{FALSE}.}

\item{crs}{terra::crs(1). Coordinate reference system (inherited from
\code{from}).}
}
\value{
a data.frame or SpatVector object (depending on \code{geom} paramter)
}
\description{
Check the time column for proper class and, if \code{geom = TRUE},
transform \code{data.frame} into a \code{SpatVector} object.
}
\author{
Mitchell Manware
}
\keyword{auxiliary}
