% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertCoord.R
\name{extractConvertCoord}
\alias{extractConvertCoord}
\title{Extract converted coordinate points from convertCoord request}
\usage{
extractConvertCoord(res)
}
\arguments{
\item{res}{Required.\cr
Response from convertCoord.}
}
\value{
Returns a tibble which extracts converted coordinate points from request of convertCoord. See \url{https://lbs.amap.com/api/webservice/guide/api/convert} for more information.
}
\description{
Extract converted coordinate points from convertCoord request
}
\examples{
\dontrun{
library(dplyr)
library(amapGeocode)

# Before the `convertCoord()` is executed,
# the token should be set by `option(amap_key = 'key')`
# or set by key argument in `convertCoord()`

# get result of converted coordinate system as a XML
convertCoord('116.481499,39.990475',coordsys = 'gps', to_table = FALSE) \%>\%
   # extract result of converted coordinate system as a tibble
   extractConvertCoord()
}

}
\seealso{
\code{\link{convertCoord}}
}
