% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zonalMeanStats.R
\name{zonalMeanStats}
\alias{zonalMeanStats}
\title{Zonal mean plots of AMBER results (bias, bias scores, etc)}
\usage{
zonalMeanStats(inputDir, outputDir = FALSE)
}
\arguments{
\item{inputDir}{A string that gives the location of NetCDF files produced by \link{scores.grid.time}, e.g. '/home/project/study'.}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
A list with two tables. The first table gives the zonal mean values of centralized root-mean-squre error, phase, inter-annual variability, and corresponding
scores for each variable and globally gridded reference data set. The second table gives the physical units of each variable in LaTeX notation (e.g. 'W m$^{-2}$').
Both tables are written to two text files (zonalMeanStats and zonalMeanStatsUnits) if the user specifies an output directory.
}
\description{
This function computes zonal mean values of model and reference data and the zonal mean bias, centralized root-mean-squre error, phase, inter-annual variability, and corresponding scores. The computation is based on the NetCDF files produced by \link{scores.grid.time}.
}
\examples{

library(amber)
library(foreach)
library(ncdf4)
library(raster)

inputDir <- paste(system.file('extdata', package = 'amber'), 'zonalMeanStats', sep = '/')
zonalMeanStats(inputDir, outputDir = FALSE)

}
