% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationMatrixDiff.R
\name{correlationMatrixDiff}
\alias{correlationMatrixDiff}
\title{Plot a matrix that shows the difference between two correlation
coefficient matrices computed by \link{correlationMatrix}.}
\usage{
correlationMatrixDiff(cm.one, cm.two, myRows = NA, myColumns = NA,
  inputDir, outputDir = FALSE, ofileName = "correlationMatrixDiff.pdf",
  plot.width = 8, plot.height = 6.8, plot.margin = c(10, 10, 1, 4))
}
\arguments{
\item{cm.one}{An R objective that gives a correlation matrix computed by \link{correlationMatrix}.}

\item{cm.two}{An R objective that gives another correlation matrix computed by \link{correlationMatrix}.}

\item{myRows}{Optional: the user can highlight relations between variables by
specifying variable names along the rows and columns of a matrix. Those relations
are then highlighted by plotting a polygon around the corresponding grid cells
and by plotting the corresponding value.}

\item{myColumns}{Optional: Same as myRows but for variable names listed along the columns of the matrix.}

\item{inputDir}{A string that gives the location of NetCDF files produced by \link{scores.grid.time}, e.g. '/home/project/study'.}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}

\item{ofileName}{A string that gives the output file name, e.g. 'myOutput.pdf'}

\item{plot.width}{A number that gives the plot width, e.g. 8}

\item{plot.height}{A number that gives the plot height, e.g. 6.8}

\item{plot.margin}{An R object that gives the plot margin, e.g. c(10, 10, 1, 4)}
}
\value{
A Figure of a matrix that shows the difference between two correlation
coefficient matrices.
}
\description{
This function plots a matrix that shows the difference between two correlation
coefficient matrices computed by \link{correlationMatrix}. This is useful for assessing how well
model data reproduces correlations that are evident in reference data. The difference is computed
as the absolute value of the first correlation matrix minus the absolute value of the second
correlation matrix.
}
\examples{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

inputDir <- paste(system.file('extdata', package = 'amber'), 'zonalMeanStats', sep = '/')
cm.one <- correlationMatrix(metric = 'bias', inputDir = inputDir)
cm.two <- correlationMatrix(metric = 'bias', inputDir = inputDir)

correlationMatrixDiff(cm.one, cm.two, inputDir = inputDir)

# You can specify certain relationships to highlight them in your correlation matrix
myRows <- c('LAI.AVHRR', 'LAI.AVHRR')
myColumns <- c('ALBS.CERES', 'GPP.FluxCom')

correlationMatrixDiff(cm.one, cm.two, inputDir = inputDir, myRows = myRows, myColumns = myColumns)

}
